* 1. Prepare results datasets of AR estimates (reduced and full)
foreach x in "ar" "aar" {
use `x'1.dta
drop if parm=="_cons"
gen model=0
gen n=_n
save `x'1p.dta, replace
clear

use `x'2.dta
drop if parm=="_cons"
gen model=1
gen n=_n
save `x'2p.dta, replace
clear

* Merge and label 
use `x'1p.dta
append using `x'2p.dta

gen min90=estimate-1.68*stderr
gen max90=estimate+1.68*stderr

label define l_model 0 "Reduced Model" 1 "Full Model"
label values model l_model

label define nlabel  1 "Def agenda" 2 "Def good news" 3 "Summit info bef" 4 "Summit info aft" 5 "Election" 6 "Referenda" 7 "Extra summit" 8 "Defense expend" 9 "EU integration (GE)" 10 "EU integration (FR)" 11 "EU integration (UK)"
label values n nlabel

eclplot estimate min90 max90 n, horizontal eplottype(scatter) rplottype(rcap) estopts( msize(medium) mcolor(black) mfcolor(black) mlcolor(white) mlabcolor(black) sort clcolor(black) ) ciopts( blpattern(solid) blwidth(medthin) blcolor(black) msize(small) ) by(model, graphregion(fcolor(white) lcolor(white) lwidth(none)) plotregion(fcolor(white) lcolor(white)) legend(off)) ytitle("") ylabel( 1 "Def agenda" 2 "Def good news" 3 "Summit info bef" 4 "Summit info aft" 5 "Election" 6 "Referenda" 7 "Extra summit" 8 "Defense expend" 9 "EU integration (GE)" 10 "EU integration (FR)" 11 "EU integration (UK)", valuelabel labsize(small) grid nogmax nogmin glwidth(none) nogextend) xtitle(Marginal effect (percentage points), size(small)) xlabel(#8, labsize(medsmall) grid glwidth(thin) glcolor(gs13)) graphregion(fcolor(white) lcolor(white) ifcolor(white) ilcolor(white))
graph save "`x'_est.gph", replace
*graph export "`x'_est.png", replace
*graph export "`x'_est.wmf", replace
*graph export "`x'_est.eps", replace


clear
erase `x'1p.dta
erase `x'1.dta
erase `x'2p.dta
erase `x'2.dta
}
