version 10
clear
set more off
use summits_an.dta

tab group_id
tab summit_id

* a) Preparations
drop if dif<-5 | dif>5
display "The following list should be empty"
sort c_id date
by c_id: list date dif if date==date[_n-1] & dif>-5 & dif<5
tsset c_id date
order group_id date
 
label variable def_imp "Def agenda"
label variable def_good "Def good news"
label variable elec_sum "Election"
label variable ref_sum "Referendum"
label variable extra_summit "Extra summit"
label variable exp_def_av "Defense exp"
label variable govpreu_de "EU integration (GE)"
label variable govpreu_fr "EU integration (FR)"
label variable govpreu_uk "EU integration (UK)"
label variable no_art_bef "Summit info before"
label variable no_art_aft "Summit info after"


* b) Estimate models
set more off
capture log close
log using results, replace
* FINAL MODELS

* AAR
* AAR-I
quietly xtreg aar def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av if dif>=-1 & dif<=5, fe
estimates store fixed
quietly xtreg aar def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av if dif>=-1 & dif<=5, re
estimates store random
hausman fixed random

xtreg aar aar def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av if dif==1, robust re
parmest, saving(aar1.dta, replace) label format(p %8.1e) stars(0.10 0.05 0.001) list(parm label estimate min95 max95 p stars,clean noobs)

* AAR-II
quietly xtreg aar def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit govpreu_de govpreu_fr govpreu_uk exp_def_av if dif>=-1 & dif<=5, fe
estimates store fixed
quietly xtreg aar def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit govpreu_de govpreu_fr govpreu_uk exp_def_av if dif>=-1 & dif<=5, re

estimates store random
hausman fixed random

xtreg aar def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit govpreu_de govpreu_fr govpreu_uk exp_def_av if dif>=-1 & dif<=5, robust re
parmest, saving(aar2.dta, replace) label format(p %8.1e) stars(0.10 0.05 0.001) list(parm label estimate min95 max95 p stars,clean noobs)

* With rile
xtreg aar def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit rile_de rile_fr rile_uk exp_def_av if dif>=-1 & dif<=5, robust re

* With Schmidt index
xtreg aar def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit gov_schm_de gov_schm_fr gov_schm_uk exp_def_av if dif>=-1 & dif<=5, robust re


* AAR - only considering event time=1 observations
* AAR-I - only considering event time=1 observations
xtreg aar aar def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av if dif==1, robust re

* AAR-II - only considering event time=1 observations
xtreg aar def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit govpreu_de govpreu_fr govpreu_uk exp_def_av if dif==1, robust re

* With rile
xtreg aar def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit rile_de rile_fr rile_uk exp_def_av if dif==1, robust re

* With Schmidt index
xtreg aar def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit gov_schm_de gov_schm_fr gov_schm_uk exp_def_av if dif==1, robust re


* AR_it
* AR-I
quietly xtreg ar_it def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av if dif>=-1 & dif<=5, fe
estimates store fixed
quietly xtreg ar_it def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av if dif>=-1 & dif<=5, re
estimates store random
hausman fixed random

xtreg ar_it def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av if dif>=-1 & dif<=5, robust re
parmest, saving(ar1.dta, replace) label format(p %8.1e) stars(0.10 0.05 0.001) list(parm label estimate min95 max95 p stars,clean noobs)

* AR-II
quietly xtreg ar_it def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av govpreu_de govpreu_fr govpreu_uk if dif>=-1 & dif<=5, fe
estimates store fixed
quietly xtreg ar_it def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av govpreu_de govpreu_fr govpreu_uk if dif>=-1 & dif<=5, re
estimates store random
hausman fixed random

xtreg ar_it def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av govpreu_de govpreu_fr govpreu_uk if dif>=-1 & dif<=5, robust re
parmest, saving(ar2.dta, replace) label format(p %8.1e) stars(0.10 0.05 0.001) list(parm label estimate min95 max95 p stars,clean noobs)

* With rile
quietly xtreg ar_it def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av rile_de rile_fr rile_uk if dif>=-1 & dif<=5, fe
estimates store fixed
quietly xtreg ar_it def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av rile_de rile_fr rile_uk if dif>=-1 & dif<=5, re
estimates store random
hausman fixed random
xtreg ar_it def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av rile_de rile_fr rile_uk if dif>=-1 & dif<=5, robust re

* With Schmidt-index
xtreg ar_it def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av gov_schm_de gov_schm_fr gov_schm_uk if dif>=-1 & dif<=5, robust re

* Newey
newey ar_it def_imp def_good no_art_bef no_art_aft elec_sum ref_sum extra_summit exp_def_av govpreu_de govpreu_fr govpreu_uk if dif>=-1 & dif<=5, lag(1) force
log close

clear
exit
