version 10
clear
set more off
use summits_an.dta
tsset group_id t


**********************************************
* 1. Compute various abormal returns 
**********************************************
rename summit_id summit_id_old2
egen summit_id=group(summit_id_old2)

* a) Calculate abnormal returns for each sector-event observation and t
gen ar_it=c_sprice_ret-pred_ret
label variable ar_it "Abnormal return of firm at time t"
order group_id t dif c_sprice_ret pred_ret ar_it 

* b) Average abnormal return across firms (for summitXt)
sort summit_id dif
egen sucoid=group(summit_id dif) if dif<5 & dif>-2
label variable sucoid "Summit observations identifier"

bysort sucoid: egen aar_si=mean(ar_it)
label variable sucoid "Average abnormal return across firms (for summitXt)"

* c) Average abnormal returns (AAR) across firms at event time t
bysort dif: egen aar_t=mean(ar_it) // average across automobile parts-event observations for given t
label variable aar_t "Average AR at event time t"

* d) Generate average abnormal return within [-1,5]-event window
sort group_id t
by group_id: egen aar=mean(ar_it) if dif>=-1 & dif<=5
label variable aar "Average abnormal return during EU summit meetings"

* e) Create identifier for number of observations per event time
bysort dif: gen dif_obs=_n
label variable dif_obs "Number of observations for event time t"
/* Later use condition "if dif_obs==1" to avoid using repeated observations */

save summits_an.dta, replace
clear
exit






