version 10
capture log close
log using 02_gra, replace
clear
use pol_graphs.dta

* A. Conditional Marginal Effects
* Unified Government
#delimit;
twoway 
(rline upper_mecdu_uni lower_mecdu_uni dlinf_supp, lcolor(gs5) lpattern(dash) lwidth(thin))
(line mecdu_uni dlinf_supp, lcolor(black) lwidth(medium) 
yline(0,lcolor(black) lpattern(shortdash))
ylabel(#7,nogrid) 
title("Unified Government",color(black))
ytitle("" "") 
xtitle("")
xlabel(-.2(.05).2)
graphregion(fcolor(white) 
lcolor(white) 
ifcolor(white) 
ilcolor(white)) 
plotregion(fcolor(white) 
lcolor(white))
legend(off)
)
;
#delimit cr
graph save "me_uni.gph", replace
*order(2 "Marginal Effect" 1 "95% Confidence Interval"))
*xtitle("Change in Inflation (%)", size(medium))


* Divided Government
#delimit;
twoway 
(rline upper_mecdu_div lower_mecdu_div dlinf_supp, lcolor(gs5) lpattern(dash) lwidth(thin))
(line mecdu_div dlinf_supp, lcolor(black) lwidth(medium) 
yline(0,lcolor(black) lpattern(shortdash))
ylabel(#7,nogrid) 
title("Divided Government",color(black))
ytitle("" "") 
xtitle("")
xlabel(-.2(.05).2)
graphregion(fcolor(white) 
lcolor(white) 
ifcolor(white) 
ilcolor(white)) 
plotregion(fcolor(white) 
lcolor(white)) 
legend(off)
)
;
#delimit cr
graph save "me_div.gph", replace
*order(2 "Marginal Effect" 1 "95% Confidence Interval"))

#delimit;
graph combine "me_uni.gph" "me_div.gph", 
cols(1) 
l1title("Effect of Government Partisanship on Risk (% points)") 
graphregion(fcolor(white)) 
ycommon
xcommon
ysize(6) 
;
#delimit cr
graph save "me_comb.gph", replace

* Significance of difference between unified and divided government partisan effect
* Divided Government
* Significance of Difference in Partisan Effect
#delimit;
line p_diff_uni dlinf_supp, lcolor(black) lwidth(medium) 
ylabel(,nogrid)
title("Significance of Difference in Partisan Effect", size(vlarge) color(black)) 
ytitle("Significance Level" "(p-value)",size(vlarge)) 
xtitle("Change in Inflation (%)", size(large))
xlabel(-.2(.05).2)
graphregion(fcolor(white) 
lcolor(white) 
ifcolor(white) 
ilcolor(white)) 
plotregion(fcolor(white) lcolor(white)) 
legend(order(2 "Marginal Effect" 1 "95% Confidence Interval"))
;
#delimit cr
graph save "me_pval.gph", replace


clear
exit

