version 10
capture log close

log using estimation, replace
clear
use political_risk_91-05.dta
*net get st0085.pkg
set more off

*get descriptives
su dlogdaxvola pcdufdp entropy coal_form incumbcdu dubratcdu grand_coal dlinflation dlinterestrate dlgdppc

*****************************
* A. Estimation
*****************************
* CDU
* I
regress dlogdaxvola pcdufdp entropy coal_form incumbcdu dubratcdu inccduXdubratcdu grand_coal dlinflation dlinflationXincumbcdu dubratcduXdlinfXincdu dlinterestrate dlgdppc dubratcduXdlinflation, robust 

newey dlogdaxvola pcdufdp entropy coal_form incumbcdu dubratcdu inccduXdubratcdu grand_coal dlinflation dlinflationXincumbcdu dubratcduXdlinfXincdu dlinterestrate dlgdppc dubratcduXdlinflation, lag(20)

* II - CDU
regress dlogdaxvola pcdufdp entropy coal_form incumbcdu dubratcdu inccduXdubratcdu grand_coal callearly05 call_noconfid05 voteofconfid05 noconfid_decision_05 const_compl_05 riot_92 riot_95 strike_95 right_wing_attack dlinflation dlinflationXincumbcdu bratcduXdlinfXincdu dlinterestrate dlgdppc desaster attack_wtc_93 attack_wtc_01 kosovo_war_99 afgh_war_99 iraq_war_03 ems_crisis92 dubratcduXdlinflation

newey dlogdaxvola pcdufdp entropy coal_form incumbcdu dubratcdu inccduXdubratcdu grand_coal callearly05 call_noconfid05 voteofconfid05 noconfid_decision_05 const_compl_05 riot_92 riot_95 strike_95 right_wing_attack dlinflation dlinflationXincumbcdu bratcduXdlinfXincdu dlinterestrate dlgdppc desaster attack_wtc_93 attack_wtc_01 kosovo_war_99 afgh_war_99 iraq_war_03 ems_crisis92 dubratcduXdlinflation, lag(20)

*********************************************
* B. Interaction: Coefficients and Graphs
*********************************************

* Prepare Data needed for graph of interaction term
* a.) Generate support of dlinflation           
*twoway (line linflation date) (line dlinflation date) (line inflation date)

gen dlinf_supp=.
* generate support from -0.20 to 0.20 percent changes in inflation
set more off
forvalues i=1(1)401 {
quietly replace dlinf_supp=(`i'-201)/1000 in `i'
}

* b.) Get data from coefficient and variance-covariance matrix 
matrix b_cdu=e(b)
matrix V_cdu=e(V)
	* coefficients
scalar b1=b_cdu[1,4] 		// incumbcdu
scalar b4=b_cdu[1,6] 		// incumbcduXdubratcdu
scalar b5=b_cdu[1,18]		// incumbcduXdlinflation
scalar b7=b_cdu[1,19]		// dubratcduXincumbcduXdlinflation
	* variance of coefficients
scalar varb1=V_cdu[4,4]
scalar varb4=V_cdu[6,6] 
scalar varb5=V_cdu[18,18] 
scalar varb7=V_cdu[19,19] 
	* covariance of coefficients
scalar covb1b4=V_cdu[4,6] 
scalar covb1b5=V_cdu[4,18]
scalar covb1b7=V_cdu[4,19]
scalar covb4b5=V_cdu[6,18]
scalar covb4b7=V_cdu[6,19]
scalar covb5b7=V_cdu[18,19]

* c.) Calculate the marginal effect of X on Y for all values Z
* if divided (dubrat=0)
gen mecdu_div=b1+b5*dlinf_supp if dlinf_supp!=.
label variable mecdu_div "Marginal Effect"
* if undified (dubrat=1)
gen mecdu_uni=b1+b4+b5*dlinf_supp+b7*dlinf_supp if dlinf_supp!=.
label variable mecdu_uni "Marginal Effect"

* d.) Calculate standard errors of marginal effects
* if divided (dubrat=0)
gen se_mecdu_div=sqrt(varb1+(dlinf_supp^2)*varb5+(dlinf_supp^2)*varb7+2*dlinf_supp*covb1b5) if dlinf_supp!=.
* if unified (dubrat=1)
gen se_mecdu_uni=sqrt(varb1+varb4+(dlinf_supp^2)*varb5+(dlinf_supp^2)*varb7+2*covb1b4+2*dlinf_supp*covb1b5+2*dlinf_supp*covb1b7+2*dlinf_supp*covb4b5+2*dlinf_supp*covb4b7+2*(dlinf_supp^2)*covb5b7) if dlinf_supp!=.

* e.) Generate upper and lower bounds CI
* for both cases (divided and unified)
foreach var of varlist mecdu_div mecdu_uni {
gen a_`var'=1.96*se_`var'
gen upper_`var'=`var'+a_`var'
label variable upper_`var' "95% CI"
gen lower_`var'=`var'-a_`var'
}

* Calculate significance of difference in coefficients between unified and divided government
gen t_diff_uni=(mecdu_uni-mecdu_div)/se_mecdu_div
label variable t_diff_uni "Difference in Coefficient Estimates (t-value)"
gen p_diff_uni= tden(1000,t_diff_uni)/2
label variable t_diff_uni "Difference in Coefficient Estimates (p-value)"
save pol_graphs.dta, replace

clear
exit

