* This do-file replicates the main results in 
* Michael M. Bechtel/Thomas Bernauer/Reto Meyer
* "The Green Side of Protectionism: Environmental Concerns 
* and Three Facets of Trade Policy Preferences." 
* In: Review of International Political Economy (forthcoming)
* 

clear
set more off
set scheme s1mono
capture log close
discard
program drop _all

log using 01_replication.smcl, replace

local k=1
* For each dependent variable
foreach mdl of numlist 3 4 6 {
		clear
		set more off
		use greenprotect.dta
		* Reduced model
		probit y`mdl'bi ubadpp aeqinct educyrs07z ausl frau talterz romand ticino prim const manu, robust
		estat class
		* Full model
		probit y`mdl'bi ubadpp iublire spol2 aeqinct educyrs07z ausl frau talterz romand ticino prim const manu, robust
		estat class
		estsimp probit y`mdl'bi ubadpp iublire spol2 aeqinct educyrs07z ausl frau talterz romand ticino prim const manu, robust
		eststo model`mdl'intbi
		
		*set all var at their mean for prediction
		setx mean
		su ubadpp, det
		local m=r(mean) /* extract mean value of ubadpp */
 		local xlo=r(mean)-r(sd)
 		local xhi=r(mean)+r(sd)

		* set local for category of dependent var (loop 1)
		set more off
		local k=1	
		* set local for LR Ideology (loop 2)
		local j=11
		
		/* Generate qis mean, ub, and lb by category as new vars, 
		each obs is one LR-Ideology value */
		
		* Generate support for LR-Ideology (used for graph)
		gen lr_supp=_n-1 if _n<=`j'+1
		label variable lr_supp "L-R Ideology"
		
		forval i=1(1)`k' { // loop over categories (only 1)
				gen mpr`i'`mdl'bi=_n if _n<=`j'
				label variable mpr`i'`mdl'bi "Effect of Environmental Awareness"
				gen ubpr`i'`mdl'bi=_n if _n<=`j'
				label variable ubpr`i'`mdl'bi "Upper Bound (95%)"
				gen lbpr`i'`mdl'bi=_n if _n<=`j'
				label variable lbpr`i'`mdl'bi "Lower Bound (95%)"
		}
		forval i=1(1)`k' { // loop over categories (only 1)
				forval a=0(1)`j' { // loop over LR Ideology (0-10)
						/* Set the x var and determin CI for graphs!*/
						setx spol2 `a'
						simqi, fd(prval(1)) changex(ubadpp `xlo' `xhi' iublire `xlo'*`a' `xhi'*`a') fd(genpr(mpr`i'_`a'`mdl'bi))
						*simqi, prval(`i') genpr(mpr`i'_`a'`mdl'bi) 
						/* Get mean Pr and store*/
						su mpr`i'_`a'`mdl'bi
						*return list	
						replace mpr`i'`mdl'bi=r(mean) if _n==`a' 
						/* Get CI and store */
						_pctile mpr`i'_`a'`mdl'bi, p(2.5,97.5) 
						* r(r1) is lower r(r2) is upper
						replace lbpr`i'`mdl'bi=r(r1) if _n==`a'
						replace ubpr`i'`mdl'bi=r(r2) if _n==`a'
						order lr_supp mpr`i'`mdl'bi ubpr`i'`mdl'bi lbpr`i'`mdl'bi
				}
		}
keep lr_supp mpr1`mdl'bi ubpr1`mdl'bi lbpr1`mdl'bi
sort lr_supp
save mpr`mdl'bi.dta, replace		
}

* Merge the estimates to the main dataset
clear
use greenprotect.dta
gen lr_supp=_n
label variable lr_supp "L-R Ideology"
sort lr_supp
keep lr_supp
drop if lr_supp>10
save bpr_results.dta, replace

foreach mdl of numlist 3 4 6{
clear
use bpr_results.dta
merge lr_supp using mpr`mdl'bi.dta
drop _merge
sort lr_supp
save bpr_results.dta, replace
}
drop if lr_supp>10

* Make Binary Probit Graphs

* Variable y3
#delimit;
twoway (rcap lbpr13bi ubpr13bi lr_supp, lwidth(medthin) 
		lpattern(solid) xline(0(1)10, lpattern(vshortdash) lcolor(gs10))) 
		(scatter mpr13bi lr_supp, mcolor(black) msize(small) msymbol(circle)), 
		title("Jobs: Sector-specific" "protection needed") ytitle("") legend(off)
			yline(0)
	;
graph save bpr_3.gph, replace;
graph export bpr3.png, as(png) replace;
			
twoway (rcap lbpr14bi ubpr14bi lr_supp, lwidth(medthin) 
		lpattern(solid) xline(0(1)10, lpattern(vshortdash) lcolor(gs10))) 
		(scatter mpr14bi lr_supp, mcolor(black) msize(small) msymbol(circle)),  
		title("Foreign goods:" "Not only price and quality") ytitle("") legend(off)
			yline(0)
	;
graph save bpr_4.gph, replace;
graph export bpr4.png, as(png) replace;

twoway (rcap lbpr16bi ubpr16bi lr_supp, lwidth(medthin) 
		lpattern(solid) xline(0(1)10, lpattern(vshortdash) lcolor(gs10))) 
		(scatter mpr16bi lr_supp, mcolor(black) msize(small) msymbol(circle)),
		title("Globalization" "More disadvantages") ytitle("Effect of Environmental Awareness [Probability Change]") legend(off)
			yline(0)
	;
graph save bpr_6.gph, replace;
graph export bpr6.png, as(png) replace;
#delimit cr
graph combine bpr_6.gph bpr_3.gph bpr_4.gph, xcommon ycommon row(1)
graph save bprcomb.gph, replace
graph export bprcomb.png, as(png) replace

clear

log close
exit

